/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ArmorPrismariteModifier
extends Modifier
implements AttributesModifierHook {
    private static final TinkerDataCapability.TinkerDataKey<Integer> WATER = TConstruct.createKey((String)"prismarite_armor");
    private static final String ATTRIBUTE_BONUS = "7a722435-9301-4e45-8f47-e18c1bb97990";

    public ArmorPrismariteModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorPrismariteModifier::onUpdateApply);
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int levels = (Integer)holder.get(WATER, (Object)0);
                if (levels > 0) {
                    if (living.m_21023_(MobEffects.f_19605_) && living.m_21124_(MobEffects.f_19605_).m_19557_() <= 100 || !living.m_21023_(MobEffects.f_19605_)) {
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200));
                    }
                    if (living.m_21023_(MobEffects.f_19599_) && UpgradedNetheriteConfig.EnableElderGuardianDebuffImmune) {
                        living.m_21195_(MobEffects.f_19599_);
                    }
                }
            });
        }
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        consumer.accept((Attribute)ForgeMod.SWIM_SPEED.get(), new AttributeModifier(UUID.fromString(ATTRIBUTE_BONUS), ForgeMod.SWIM_SPEED.toString(), (double)(0.1f * modifier.getEffectiveLevel()), AttributeModifier.Operation.MULTIPLY_BASE));
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.ATTRIBUTES);
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(WATER, false, null));
    }
}

